//
//  $Id: AHKABArrayController.h 98 2009-06-12 17:01:44Z fujidana $
//  Copyright (c) 2005-2009 Fujidana All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "AHKUniquelyNumberedArrayController.h"

extern NSString	*AHKABRowIndexesPboardType;
//extern NSString *AHKABPeoplePboardType;

@class AHKABMainWindowController;

@interface AHKABArrayController : AHKUniquelyNumberedArrayController
{
	IBOutlet AHKABMainWindowController *mainWindowController;
    IBOutlet NSTableView               *contentTableView;
	IBOutlet NSSearchField             *searchField;
	
	NSString *oldSearchString;
	int      searchFilterTag;
}

- (void)awakeFromNib;

- (IBAction)search:(id)sender;
- (NSString *)searchString;
- (void)setSearchString:(NSString *)value;

- (IBAction)selectSearchFilters:(id)sender;
- (int)searchFilterTag;
- (void)setSearchFilterTag:(int)value;
- (NSArray *)searchFilterKeys;

// - (void)insertObject:(id)object atArrangedObjectIndex:(unsigned int)index;
// - (NSArray *)arrangeObjects:(NSArray *)objects;

//#pragma mark utility methods
//- (void)restoreArrangementAndSelection;

@end


@interface AHKABArrayController (Dragging)

- (void)registerTableViewForDraggedTypes;

@end

